<?php
/**
 * RowsBatchApi
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Cms\Hubdb
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Hubdb
 *
 * HubDB is a relational data store that presents data as rows, columns, and cells in a table, much like a spreadsheet. HubDB tables can be added or modified [in the HubSpot CMS](https://knowledge.hubspot.com/cos-general/how-to-edit-hubdb-tables), but you can also use the API endpoints documented here. For more information on HubDB tables and using their data on a HubSpot site, see the [CMS developers site](https://designers.hubspot.com/docs/tools/hubdb). You can also see the [documentation for dynamic pages](https://designers.hubspot.com/docs/tutorials/how-to-build-dynamic-pages-with-hubdb) for more details about the `useForPages` field.  HubDB tables support `draft` and `published` versions. This allows you to update data in the table, either for testing or to allow for a manual approval process, without affecting any live pages using the existing data. Draft data can be reviewed, and published by a user working in HubSpot or published via the API. Draft data can also be discarded, allowing users to go back to the published version of the data without disrupting it. If a table is set to be `allowed for public access`, you can access the published version of the table and rows without any authentication by specifying the portal id via the query parameter `portalId`.
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Cms\Hubdb\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use HubSpot\Client\Cms\Hubdb\ApiException;
use HubSpot\Client\Cms\Hubdb\Configuration;
use HubSpot\Client\Cms\Hubdb\HeaderSelector;
use HubSpot\Client\Cms\Hubdb\ObjectSerializer;

/**
 * RowsBatchApi Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Cms\Hubdb
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class RowsBatchApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'cloneDraftTableRows' => [
            'application/json',
        ],
        'createDraftTableRows' => [
            'application/json',
        ],
        'purgeDraftTableRows' => [
            'application/json',
        ],
        'readDraftTableRows' => [
            'application/json',
        ],
        'readTableRows' => [
            'application/json',
        ],
        'replaceDraftTableRows' => [
            'application/json',
        ],
        'updateDraftTableRows' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation cloneDraftTableRows
     *
     * Clone rows in batch
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputString $batch_input_string The JSON array of row ids (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['cloneDraftTableRows'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3|\HubSpot\Client\Cms\Hubdb\Model\Error
     */
    public function cloneDraftTableRows($table_id_or_name, $batch_input_string, string $contentType = self::contentTypes['cloneDraftTableRows'][0])
    {
        list($response) = $this->cloneDraftTableRowsWithHttpInfo($table_id_or_name, $batch_input_string, $contentType);
        return $response;
    }

    /**
     * Operation cloneDraftTableRowsWithHttpInfo
     *
     * Clone rows in batch
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputString $batch_input_string The JSON array of row ids (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['cloneDraftTableRows'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3|\HubSpot\Client\Cms\Hubdb\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function cloneDraftTableRowsWithHttpInfo($table_id_or_name, $batch_input_string, string $contentType = self::contentTypes['cloneDraftTableRows'][0])
    {
        $request = $this->cloneDraftTableRowsRequest($table_id_or_name, $batch_input_string, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation cloneDraftTableRowsAsync
     *
     * Clone rows in batch
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputString $batch_input_string The JSON array of row ids (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['cloneDraftTableRows'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function cloneDraftTableRowsAsync($table_id_or_name, $batch_input_string, string $contentType = self::contentTypes['cloneDraftTableRows'][0])
    {
        return $this->cloneDraftTableRowsAsyncWithHttpInfo($table_id_or_name, $batch_input_string, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation cloneDraftTableRowsAsyncWithHttpInfo
     *
     * Clone rows in batch
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputString $batch_input_string The JSON array of row ids (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['cloneDraftTableRows'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function cloneDraftTableRowsAsyncWithHttpInfo($table_id_or_name, $batch_input_string, string $contentType = self::contentTypes['cloneDraftTableRows'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3';
        $request = $this->cloneDraftTableRowsRequest($table_id_or_name, $batch_input_string, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'cloneDraftTableRows'
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputString $batch_input_string The JSON array of row ids (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['cloneDraftTableRows'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function cloneDraftTableRowsRequest($table_id_or_name, $batch_input_string, string $contentType = self::contentTypes['cloneDraftTableRows'][0])
    {

        // verify the required parameter 'table_id_or_name' is set
        if ($table_id_or_name === null || (is_array($table_id_or_name) && count($table_id_or_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id_or_name when calling cloneDraftTableRows'
            );
        }

        // verify the required parameter 'batch_input_string' is set
        if ($batch_input_string === null || (is_array($batch_input_string) && count($batch_input_string) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_string when calling cloneDraftTableRows'
            );
        }


        $resourcePath = '/cms/v3/hubdb/tables/{tableIdOrName}/rows/draft/batch/clone';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($table_id_or_name !== null) {
            $resourcePath = str_replace(
                '{' . 'tableIdOrName' . '}',
                ObjectSerializer::toPathValue($table_id_or_name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($batch_input_string)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($batch_input_string));
            } else {
                $httpBody = $batch_input_string;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createDraftTableRows
     *
     * Create rows in batch
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputHubDbTableRowV3Request $batch_input_hub_db_table_row_v3_request JSON array of row objects (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createDraftTableRows'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3|\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors|\HubSpot\Client\Cms\Hubdb\Model\Error
     */
    public function createDraftTableRows($table_id_or_name, $batch_input_hub_db_table_row_v3_request, string $contentType = self::contentTypes['createDraftTableRows'][0])
    {
        list($response) = $this->createDraftTableRowsWithHttpInfo($table_id_or_name, $batch_input_hub_db_table_row_v3_request, $contentType);
        return $response;
    }

    /**
     * Operation createDraftTableRowsWithHttpInfo
     *
     * Create rows in batch
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputHubDbTableRowV3Request $batch_input_hub_db_table_row_v3_request JSON array of row objects (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createDraftTableRows'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3|\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors|\HubSpot\Client\Cms\Hubdb\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createDraftTableRowsWithHttpInfo($table_id_or_name, $batch_input_hub_db_table_row_v3_request, string $contentType = self::contentTypes['createDraftTableRows'][0])
    {
        $request = $this->createDraftTableRowsRequest($table_id_or_name, $batch_input_hub_db_table_row_v3_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 207:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 207:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createDraftTableRowsAsync
     *
     * Create rows in batch
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputHubDbTableRowV3Request $batch_input_hub_db_table_row_v3_request JSON array of row objects (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createDraftTableRows'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createDraftTableRowsAsync($table_id_or_name, $batch_input_hub_db_table_row_v3_request, string $contentType = self::contentTypes['createDraftTableRows'][0])
    {
        return $this->createDraftTableRowsAsyncWithHttpInfo($table_id_or_name, $batch_input_hub_db_table_row_v3_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createDraftTableRowsAsyncWithHttpInfo
     *
     * Create rows in batch
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputHubDbTableRowV3Request $batch_input_hub_db_table_row_v3_request JSON array of row objects (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createDraftTableRows'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createDraftTableRowsAsyncWithHttpInfo($table_id_or_name, $batch_input_hub_db_table_row_v3_request, string $contentType = self::contentTypes['createDraftTableRows'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3';
        $request = $this->createDraftTableRowsRequest($table_id_or_name, $batch_input_hub_db_table_row_v3_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createDraftTableRows'
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputHubDbTableRowV3Request $batch_input_hub_db_table_row_v3_request JSON array of row objects (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createDraftTableRows'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createDraftTableRowsRequest($table_id_or_name, $batch_input_hub_db_table_row_v3_request, string $contentType = self::contentTypes['createDraftTableRows'][0])
    {

        // verify the required parameter 'table_id_or_name' is set
        if ($table_id_or_name === null || (is_array($table_id_or_name) && count($table_id_or_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id_or_name when calling createDraftTableRows'
            );
        }

        // verify the required parameter 'batch_input_hub_db_table_row_v3_request' is set
        if ($batch_input_hub_db_table_row_v3_request === null || (is_array($batch_input_hub_db_table_row_v3_request) && count($batch_input_hub_db_table_row_v3_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_hub_db_table_row_v3_request when calling createDraftTableRows'
            );
        }


        $resourcePath = '/cms/v3/hubdb/tables/{tableIdOrName}/rows/draft/batch/create';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($table_id_or_name !== null) {
            $resourcePath = str_replace(
                '{' . 'tableIdOrName' . '}',
                ObjectSerializer::toPathValue($table_id_or_name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($batch_input_hub_db_table_row_v3_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($batch_input_hub_db_table_row_v3_request));
            } else {
                $httpBody = $batch_input_hub_db_table_row_v3_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation purgeDraftTableRows
     *
     * Permanently deletes rows
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputString $batch_input_string JSON array of row ids. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['purgeDraftTableRows'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function purgeDraftTableRows($table_id_or_name, $batch_input_string, string $contentType = self::contentTypes['purgeDraftTableRows'][0])
    {
        $this->purgeDraftTableRowsWithHttpInfo($table_id_or_name, $batch_input_string, $contentType);
    }

    /**
     * Operation purgeDraftTableRowsWithHttpInfo
     *
     * Permanently deletes rows
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputString $batch_input_string JSON array of row ids. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['purgeDraftTableRows'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function purgeDraftTableRowsWithHttpInfo($table_id_or_name, $batch_input_string, string $contentType = self::contentTypes['purgeDraftTableRows'][0])
    {
        $request = $this->purgeDraftTableRowsRequest($table_id_or_name, $batch_input_string, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation purgeDraftTableRowsAsync
     *
     * Permanently deletes rows
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputString $batch_input_string JSON array of row ids. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['purgeDraftTableRows'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function purgeDraftTableRowsAsync($table_id_or_name, $batch_input_string, string $contentType = self::contentTypes['purgeDraftTableRows'][0])
    {
        return $this->purgeDraftTableRowsAsyncWithHttpInfo($table_id_or_name, $batch_input_string, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation purgeDraftTableRowsAsyncWithHttpInfo
     *
     * Permanently deletes rows
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputString $batch_input_string JSON array of row ids. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['purgeDraftTableRows'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function purgeDraftTableRowsAsyncWithHttpInfo($table_id_or_name, $batch_input_string, string $contentType = self::contentTypes['purgeDraftTableRows'][0])
    {
        $returnType = '';
        $request = $this->purgeDraftTableRowsRequest($table_id_or_name, $batch_input_string, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'purgeDraftTableRows'
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputString $batch_input_string JSON array of row ids. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['purgeDraftTableRows'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function purgeDraftTableRowsRequest($table_id_or_name, $batch_input_string, string $contentType = self::contentTypes['purgeDraftTableRows'][0])
    {

        // verify the required parameter 'table_id_or_name' is set
        if ($table_id_or_name === null || (is_array($table_id_or_name) && count($table_id_or_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id_or_name when calling purgeDraftTableRows'
            );
        }

        // verify the required parameter 'batch_input_string' is set
        if ($batch_input_string === null || (is_array($batch_input_string) && count($batch_input_string) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_string when calling purgeDraftTableRows'
            );
        }


        $resourcePath = '/cms/v3/hubdb/tables/{tableIdOrName}/rows/draft/batch/purge';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($table_id_or_name !== null) {
            $resourcePath = str_replace(
                '{' . 'tableIdOrName' . '}',
                ObjectSerializer::toPathValue($table_id_or_name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($batch_input_string)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($batch_input_string));
            } else {
                $httpBody = $batch_input_string;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation readDraftTableRows
     *
     * Get a set of rows from draft table
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputString $batch_input_string JSON array of row ids. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['readDraftTableRows'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3|\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors|\HubSpot\Client\Cms\Hubdb\Model\Error
     */
    public function readDraftTableRows($table_id_or_name, $batch_input_string, string $contentType = self::contentTypes['readDraftTableRows'][0])
    {
        list($response) = $this->readDraftTableRowsWithHttpInfo($table_id_or_name, $batch_input_string, $contentType);
        return $response;
    }

    /**
     * Operation readDraftTableRowsWithHttpInfo
     *
     * Get a set of rows from draft table
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputString $batch_input_string JSON array of row ids. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['readDraftTableRows'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3|\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors|\HubSpot\Client\Cms\Hubdb\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function readDraftTableRowsWithHttpInfo($table_id_or_name, $batch_input_string, string $contentType = self::contentTypes['readDraftTableRows'][0])
    {
        $request = $this->readDraftTableRowsRequest($table_id_or_name, $batch_input_string, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 207:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 207:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation readDraftTableRowsAsync
     *
     * Get a set of rows from draft table
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputString $batch_input_string JSON array of row ids. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['readDraftTableRows'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function readDraftTableRowsAsync($table_id_or_name, $batch_input_string, string $contentType = self::contentTypes['readDraftTableRows'][0])
    {
        return $this->readDraftTableRowsAsyncWithHttpInfo($table_id_or_name, $batch_input_string, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation readDraftTableRowsAsyncWithHttpInfo
     *
     * Get a set of rows from draft table
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputString $batch_input_string JSON array of row ids. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['readDraftTableRows'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function readDraftTableRowsAsyncWithHttpInfo($table_id_or_name, $batch_input_string, string $contentType = self::contentTypes['readDraftTableRows'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3';
        $request = $this->readDraftTableRowsRequest($table_id_or_name, $batch_input_string, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'readDraftTableRows'
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputString $batch_input_string JSON array of row ids. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['readDraftTableRows'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function readDraftTableRowsRequest($table_id_or_name, $batch_input_string, string $contentType = self::contentTypes['readDraftTableRows'][0])
    {

        // verify the required parameter 'table_id_or_name' is set
        if ($table_id_or_name === null || (is_array($table_id_or_name) && count($table_id_or_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id_or_name when calling readDraftTableRows'
            );
        }

        // verify the required parameter 'batch_input_string' is set
        if ($batch_input_string === null || (is_array($batch_input_string) && count($batch_input_string) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_string when calling readDraftTableRows'
            );
        }


        $resourcePath = '/cms/v3/hubdb/tables/{tableIdOrName}/rows/draft/batch/read';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($table_id_or_name !== null) {
            $resourcePath = str_replace(
                '{' . 'tableIdOrName' . '}',
                ObjectSerializer::toPathValue($table_id_or_name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($batch_input_string)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($batch_input_string));
            } else {
                $httpBody = $batch_input_string;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation readTableRows
     *
     * Get a set of rows
     *
     * @param  string $table_id_or_name The ID or name of the table to query. (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputString $batch_input_string The JSON array of row ids (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['readTableRows'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3|\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors|\HubSpot\Client\Cms\Hubdb\Model\Error
     */
    public function readTableRows($table_id_or_name, $batch_input_string, string $contentType = self::contentTypes['readTableRows'][0])
    {
        list($response) = $this->readTableRowsWithHttpInfo($table_id_or_name, $batch_input_string, $contentType);
        return $response;
    }

    /**
     * Operation readTableRowsWithHttpInfo
     *
     * Get a set of rows
     *
     * @param  string $table_id_or_name The ID or name of the table to query. (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputString $batch_input_string The JSON array of row ids (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['readTableRows'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3|\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors|\HubSpot\Client\Cms\Hubdb\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function readTableRowsWithHttpInfo($table_id_or_name, $batch_input_string, string $contentType = self::contentTypes['readTableRows'][0])
    {
        $request = $this->readTableRowsRequest($table_id_or_name, $batch_input_string, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 207:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 207:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation readTableRowsAsync
     *
     * Get a set of rows
     *
     * @param  string $table_id_or_name The ID or name of the table to query. (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputString $batch_input_string The JSON array of row ids (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['readTableRows'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function readTableRowsAsync($table_id_or_name, $batch_input_string, string $contentType = self::contentTypes['readTableRows'][0])
    {
        return $this->readTableRowsAsyncWithHttpInfo($table_id_or_name, $batch_input_string, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation readTableRowsAsyncWithHttpInfo
     *
     * Get a set of rows
     *
     * @param  string $table_id_or_name The ID or name of the table to query. (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputString $batch_input_string The JSON array of row ids (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['readTableRows'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function readTableRowsAsyncWithHttpInfo($table_id_or_name, $batch_input_string, string $contentType = self::contentTypes['readTableRows'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3';
        $request = $this->readTableRowsRequest($table_id_or_name, $batch_input_string, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'readTableRows'
     *
     * @param  string $table_id_or_name The ID or name of the table to query. (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputString $batch_input_string The JSON array of row ids (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['readTableRows'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function readTableRowsRequest($table_id_or_name, $batch_input_string, string $contentType = self::contentTypes['readTableRows'][0])
    {

        // verify the required parameter 'table_id_or_name' is set
        if ($table_id_or_name === null || (is_array($table_id_or_name) && count($table_id_or_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id_or_name when calling readTableRows'
            );
        }

        // verify the required parameter 'batch_input_string' is set
        if ($batch_input_string === null || (is_array($batch_input_string) && count($batch_input_string) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_string when calling readTableRows'
            );
        }


        $resourcePath = '/cms/v3/hubdb/tables/{tableIdOrName}/rows/batch/read';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($table_id_or_name !== null) {
            $resourcePath = str_replace(
                '{' . 'tableIdOrName' . '}',
                ObjectSerializer::toPathValue($table_id_or_name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($batch_input_string)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($batch_input_string));
            } else {
                $httpBody = $batch_input_string;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation replaceDraftTableRows
     *
     * Replace rows in batch in draft table
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputHubDbTableRowV3BatchUpdateRequest $batch_input_hub_db_table_row_v3_batch_update_request JSON array of row objects. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['replaceDraftTableRows'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3|\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors|\HubSpot\Client\Cms\Hubdb\Model\Error
     */
    public function replaceDraftTableRows($table_id_or_name, $batch_input_hub_db_table_row_v3_batch_update_request, string $contentType = self::contentTypes['replaceDraftTableRows'][0])
    {
        list($response) = $this->replaceDraftTableRowsWithHttpInfo($table_id_or_name, $batch_input_hub_db_table_row_v3_batch_update_request, $contentType);
        return $response;
    }

    /**
     * Operation replaceDraftTableRowsWithHttpInfo
     *
     * Replace rows in batch in draft table
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputHubDbTableRowV3BatchUpdateRequest $batch_input_hub_db_table_row_v3_batch_update_request JSON array of row objects. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['replaceDraftTableRows'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3|\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors|\HubSpot\Client\Cms\Hubdb\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function replaceDraftTableRowsWithHttpInfo($table_id_or_name, $batch_input_hub_db_table_row_v3_batch_update_request, string $contentType = self::contentTypes['replaceDraftTableRows'][0])
    {
        $request = $this->replaceDraftTableRowsRequest($table_id_or_name, $batch_input_hub_db_table_row_v3_batch_update_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 207:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 207:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation replaceDraftTableRowsAsync
     *
     * Replace rows in batch in draft table
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputHubDbTableRowV3BatchUpdateRequest $batch_input_hub_db_table_row_v3_batch_update_request JSON array of row objects. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['replaceDraftTableRows'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function replaceDraftTableRowsAsync($table_id_or_name, $batch_input_hub_db_table_row_v3_batch_update_request, string $contentType = self::contentTypes['replaceDraftTableRows'][0])
    {
        return $this->replaceDraftTableRowsAsyncWithHttpInfo($table_id_or_name, $batch_input_hub_db_table_row_v3_batch_update_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation replaceDraftTableRowsAsyncWithHttpInfo
     *
     * Replace rows in batch in draft table
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputHubDbTableRowV3BatchUpdateRequest $batch_input_hub_db_table_row_v3_batch_update_request JSON array of row objects. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['replaceDraftTableRows'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function replaceDraftTableRowsAsyncWithHttpInfo($table_id_or_name, $batch_input_hub_db_table_row_v3_batch_update_request, string $contentType = self::contentTypes['replaceDraftTableRows'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3';
        $request = $this->replaceDraftTableRowsRequest($table_id_or_name, $batch_input_hub_db_table_row_v3_batch_update_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'replaceDraftTableRows'
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputHubDbTableRowV3BatchUpdateRequest $batch_input_hub_db_table_row_v3_batch_update_request JSON array of row objects. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['replaceDraftTableRows'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function replaceDraftTableRowsRequest($table_id_or_name, $batch_input_hub_db_table_row_v3_batch_update_request, string $contentType = self::contentTypes['replaceDraftTableRows'][0])
    {

        // verify the required parameter 'table_id_or_name' is set
        if ($table_id_or_name === null || (is_array($table_id_or_name) && count($table_id_or_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id_or_name when calling replaceDraftTableRows'
            );
        }

        // verify the required parameter 'batch_input_hub_db_table_row_v3_batch_update_request' is set
        if ($batch_input_hub_db_table_row_v3_batch_update_request === null || (is_array($batch_input_hub_db_table_row_v3_batch_update_request) && count($batch_input_hub_db_table_row_v3_batch_update_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_hub_db_table_row_v3_batch_update_request when calling replaceDraftTableRows'
            );
        }


        $resourcePath = '/cms/v3/hubdb/tables/{tableIdOrName}/rows/draft/batch/replace';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($table_id_or_name !== null) {
            $resourcePath = str_replace(
                '{' . 'tableIdOrName' . '}',
                ObjectSerializer::toPathValue($table_id_or_name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($batch_input_hub_db_table_row_v3_batch_update_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($batch_input_hub_db_table_row_v3_batch_update_request));
            } else {
                $httpBody = $batch_input_hub_db_table_row_v3_batch_update_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateDraftTableRows
     *
     * Update rows in batch in draft table
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputHubDbTableRowV3BatchUpdateRequest $batch_input_hub_db_table_row_v3_batch_update_request JSON array of row objects. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateDraftTableRows'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3|\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors|\HubSpot\Client\Cms\Hubdb\Model\Error
     */
    public function updateDraftTableRows($table_id_or_name, $batch_input_hub_db_table_row_v3_batch_update_request, string $contentType = self::contentTypes['updateDraftTableRows'][0])
    {
        list($response) = $this->updateDraftTableRowsWithHttpInfo($table_id_or_name, $batch_input_hub_db_table_row_v3_batch_update_request, $contentType);
        return $response;
    }

    /**
     * Operation updateDraftTableRowsWithHttpInfo
     *
     * Update rows in batch in draft table
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputHubDbTableRowV3BatchUpdateRequest $batch_input_hub_db_table_row_v3_batch_update_request JSON array of row objects. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateDraftTableRows'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3|\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors|\HubSpot\Client\Cms\Hubdb\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateDraftTableRowsWithHttpInfo($table_id_or_name, $batch_input_hub_db_table_row_v3_batch_update_request, string $contentType = self::contentTypes['updateDraftTableRows'][0])
    {
        $request = $this->updateDraftTableRowsRequest($table_id_or_name, $batch_input_hub_db_table_row_v3_batch_update_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 207:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 207:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3WithErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateDraftTableRowsAsync
     *
     * Update rows in batch in draft table
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputHubDbTableRowV3BatchUpdateRequest $batch_input_hub_db_table_row_v3_batch_update_request JSON array of row objects. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateDraftTableRows'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateDraftTableRowsAsync($table_id_or_name, $batch_input_hub_db_table_row_v3_batch_update_request, string $contentType = self::contentTypes['updateDraftTableRows'][0])
    {
        return $this->updateDraftTableRowsAsyncWithHttpInfo($table_id_or_name, $batch_input_hub_db_table_row_v3_batch_update_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateDraftTableRowsAsyncWithHttpInfo
     *
     * Update rows in batch in draft table
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputHubDbTableRowV3BatchUpdateRequest $batch_input_hub_db_table_row_v3_batch_update_request JSON array of row objects. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateDraftTableRows'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateDraftTableRowsAsyncWithHttpInfo($table_id_or_name, $batch_input_hub_db_table_row_v3_batch_update_request, string $contentType = self::contentTypes['updateDraftTableRows'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Hubdb\Model\BatchResponseHubDbTableRowV3';
        $request = $this->updateDraftTableRowsRequest($table_id_or_name, $batch_input_hub_db_table_row_v3_batch_update_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateDraftTableRows'
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\BatchInputHubDbTableRowV3BatchUpdateRequest $batch_input_hub_db_table_row_v3_batch_update_request JSON array of row objects. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateDraftTableRows'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateDraftTableRowsRequest($table_id_or_name, $batch_input_hub_db_table_row_v3_batch_update_request, string $contentType = self::contentTypes['updateDraftTableRows'][0])
    {

        // verify the required parameter 'table_id_or_name' is set
        if ($table_id_or_name === null || (is_array($table_id_or_name) && count($table_id_or_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id_or_name when calling updateDraftTableRows'
            );
        }

        // verify the required parameter 'batch_input_hub_db_table_row_v3_batch_update_request' is set
        if ($batch_input_hub_db_table_row_v3_batch_update_request === null || (is_array($batch_input_hub_db_table_row_v3_batch_update_request) && count($batch_input_hub_db_table_row_v3_batch_update_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_hub_db_table_row_v3_batch_update_request when calling updateDraftTableRows'
            );
        }


        $resourcePath = '/cms/v3/hubdb/tables/{tableIdOrName}/rows/draft/batch/update';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($table_id_or_name !== null) {
            $resourcePath = str_replace(
                '{' . 'tableIdOrName' . '}',
                ObjectSerializer::toPathValue($table_id_or_name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($batch_input_hub_db_table_row_v3_batch_update_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($batch_input_hub_db_table_row_v3_batch_update_request));
            } else {
                $httpBody = $batch_input_hub_db_table_row_v3_batch_update_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
