<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class UserPebblely extends Model
{
    use HasFactory;

    protected $table = "pebblely";

    protected $fillable = [
        "user_id",
        "image"
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id', "id");
    }
}
